package com.agilex.healthcare.config;


import com.agilex.healthcare.veteranappointment.serializer.JSONJAXBContextResolver;
import gov.va.vamf.scheduling.direct.web.XSSRequestFilter;
import gov.va.vamf.security.v1.filters.JwtAuthResourceFilter;
import gov.va.vamf.security.v1.filters.JwtAuthRoleFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spring.scope.RequestContextFilter;

public class VeteranAppointmentRequestServiceConfig extends ResourceConfig{

    String[] packages = {
            "com.agilex.healthcare.directscheduling",
            "com.agilex.healthcare.veteranappointment",
            "gov.va.vamf.scheduling.direct",
            "gov.va.vamf.scheduling.communitycare",
            "gov.va.vamf.scheduling.facility"};

    public VeteranAppointmentRequestServiceConfig() {

        register(JacksonFeature.class);
        register(JSONJAXBContextResolver.class);
        register(RequestContextFilter.class);
        register(XSSRequestFilter.class);
        register(JwtAuthResourceFilter.class);
        register(JwtAuthRoleFilter.class);
        packages(packages);
    }
}
